<?php
session_start();
require_once __DIR__.'/config.php';

// Sin login mientras SKIP_AUTH sea true (no te manda a index.php)
if (empty($_SESSION['autenticado']) && !SKIP_AUTH) {
  // header('Location: index.php'); exit();
}

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

// Días y secciones (tu checklist actual)
$days = ["Lunes","Martes","Miércoles","Jueves","Viernes","Sábado"];
$sections = [
  "General Cleaning – Lobby, Offices, Hallways, Conference Room" => [
    "Clean glass entrance and employee entrance doors of fingerprints and smudges",
    "Spot clean interior glass",
    "Dust horizontal surfaces (counters, file cabinet tops)",
    "Spot clean horizontal surfaces to remove spots and spills",
    "Clean and disinfect drinking/water fountains",
    "Clean and disinfect light switches, switch plates, and door handles",
    "Clean doors of fingerprints and smudges",
    "Empty all wastepaper receptacles and replace liners",
    "Vacuum and wipe down furniture (fabric and hard surfaces)",
    "High dusting (air vents, tops of doors, frames, ceiling corners, blinds)",
    "Low dusting (front/sides of desks, chair/table legs, bases)",
  ],
  "Floor Care – Tile, Sealed Concrete" => [
    "Vacuum, sweep or dust mop all hard surface floors",
    "Vacuum all carpeted areas",
    "Vacuum walk-off mats inside office area",
    "Thoroughly mop all hard surface floors",
    "Remove spots and small spills from carpet",
    "Vacuum, sweep or dust mop Front Bay Area",
    "Mop Front Bay Area",
    "Sweep or dust mop Back Bay Area",
    "Dust and wipe down baseboards",
  ],
  "Restroom Cleaning" => [
    "Clean countertops, washbasins, toilets, toilet seats and urinals",
    "Wipe down all dispensers, fixtures and mirrors",
    "Empty trash receptacles and replace liners",
    "Empty sanitary napkin receptacle and disinfect",
    "Spot clean partitions and tile walls around toilets and urinals",
    "Clean partitions and tile walls around toilets and urinals",
    "Restock hand soap, paper products, and soap from customer stock",
    "Clean and disinfect partition handles, door handles and light switches",
    "Clean outsides of trash receptacles",
    "Sweep and thoroughly mop the floor with germicidal solution",
    "High dusting – tops of partitions, air vents, mirror frames and tops of doors",
  ],
  "Break Areas – Breakroom / Kitchen" => [
    "Clean and disinfect counters and tabletops",
    "Spot check fronts of counters and clean",
    "Clean sinks and drains",
    "Clean and disinfect light switches, plate covers, and door handles",
    "Clean outside of refrigerators, microwaves, and other small appliances",
    "Clean inside of microwave & refrigerator",
    "Empty receptacles and replace liners",
    "Replenish soap, paper towels, etc. with customer stock as needed",
    "Low dusting – table bases and chair legs",
  ],
];

// Productos de inventario (precargados)
$inventoryProducts = [
  "Soap refill / Neutro",
  "Soap refill / Lavanda",
  "Soap refill / amarillo",
  "Antibacterial refill",
  "Hand Cleaners",
  "Box kraft Waxed",
  "Anti microbial",
  "Dust No 36",
  "Dust No 24",
  "Dust No 48",
  "Map",
  "Box black can liner 60G",
  "Box Trans can liner 16G",
  "Box Trans can liner 33G",
  "rolls paper Tawer",
  "Rolls mini jumbo bath tissue",
  "Clorox",
  "Clorox Toilet Bown",
  "Glass Cleaners",
  "Microfiber Cleaning",
  "All purpuse cleaning",
  "Scotch brite",
  "Broom handle for Dust No 36",
  "Broom handle for Dust No 24",
  "Broom handle for Dust No 48",
  "Rubbermaid Comercial",
  "Dish detergent"
];

// Flash message
$flash = $_SESSION['flash'] ?? null;
unset($_SESSION['flash']);

$today = date('Y-m-d');
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Cleaning Schedule — Checklist + Inventario</title>
<link rel="stylesheet" href="assets/style.css">
<style>
  /* Tabs */
  .tabs{max-width:1000px;margin:12px auto 0;padding:0 16px}
  .tabbar{display:flex;gap:8px}
  .tabbar button{background:#e9f1f4;color:#0f172a;border:1px solid #d5dee3;padding:10px 14px;border-radius:10px;font-weight:700;cursor:pointer}
  .tabbar button.active{background:#1e637e;color:#fff;border-color:#1e637e}
  .tab{display:none}
  .tab.active{display:block}

  /* Inventario table */
  .itable{width:100%;border-collapse:collapse;border:1px solid #e5e7eb;border-radius:10px;overflow:hidden}
  .itable th,.itable td{border:1px solid #e5e7eb;padding:8px 10px;vertical-align:top}
  .itable th{background:#e9f1f4}
  .row-actions{display:flex;gap:8px;align-items:center}
  .add-row{background:#1e637e;color:#fff;border:none;border-radius:10px;padding:8px 12px;font-weight:700;cursor:pointer}
  .del-row{background:#fee2e2;color:#991b1b;border:1px solid #ef4444;border-radius:8px;padding:6px 10px;cursor:pointer}
</style>
</head>
<body>

<?php if ($flash): ?>
  <div class="alert <?= $flash['type']==='ok' ? 'ok' : 'err' ?>">
    <?= h($flash['text']) ?>
  </div>
<?php endif; ?>

<div class="wrap">
  <form method="post" action="send.php" class="card" id="mainForm">
    <div class="card__head" style="display:flex;align-items:center">
      <div>
        <h1>Cleaning Schedule — Checklist</h1>
        <p style="margin:6px 0 0 0;opacity:.95">Se enviará por correo a <?=h(TO_EMAIL)?></p>
      </div>
      <img class="logo" src="https://thefreakyclean.com/wp-content/uploads/2024/04/Cleaning-Services-Charlotte-NC.png" alt="FreakyClean Logo" style="display:block;margin-left:auto;height:40px;">
    </div>

    <!-- Tabs header -->
    <div class="tabs">
      <div class="tabbar">
        <button type="button" class="active" data-tab="tab-checklist">Checklist</button>
        <button type="button" data-tab="tab-inventario">Inventario</button>
      </div>
    </div>

    <!-- META -->
    <div style="padding:16px 16px 0">
      <div class="meta">
        <input type="text" name="client" placeholder="Client">
        <input type="text" name="by" placeholder="By">
        <input type="text" name="name" placeholder="Name">
        <input type="text" name="title" placeholder="Title">
        <input type="date" name="date" value="<?=h($today)?>">
      </div>
      <!-- Correo destino oculto -->
      <input type="hidden" name="to" value="<?=h(TO_EMAIL)?>">
    </div>

    <!-- TAB: CHECKLIST -->
    <div id="tab-checklist" class="tab active" style="padding:0 16px 16px">
      <table class="table">
        <thead>
          <tr>
            <th style="text-align:left">Task</th>
            <?php foreach($days as $d): ?>
              <th><?=h($d)?></th>
            <?php endforeach; ?>
          </tr>
        </thead>
        <tbody>
          <?php $sec=0; foreach ($sections as $sectionTitle => $tasks): ?>
            <!-- Enviar también el nombre real de la sección -->
            <input type="hidden" name="section_names[<?=$sec?>]" value="<?=h($sectionTitle)?>">
            <tr><td class="sec-head" colspan="<?=count($days)+1?>"><?=h($sectionTitle)?></td></tr>

            <?php $t=0; foreach ($tasks as $task): ?>
              <!-- Enviar también el nombre real de la tarea -->
              <input type="hidden" name="task_names[<?=$sec?>][<?=$t?>]" value="<?=h($task)?>">
              <tr>
                <td><?=h($task)?></td>
                <?php for ($i=0;$i<count($days);$i++): ?>
                  <td style="text-align:center">
                    <input type="checkbox" name="tasks[<?=$sec?>][<?=$t?>][<?=$i?>]" value="1">
                  </td>
                <?php endfor; ?>
              </tr>
            <?php $t++; endforeach; ?>
          <?php $sec++; endforeach; ?>
        </tbody>
      </table>
    </div>

    <!-- TAB: INVENTARIO -->
    <div id="tab-inventario" class="tab" style="padding:0 16px 16px">
      <h2 style="margin:10px 0;color:#1e637e">Inventario</h2>
      <p class="muted" style="margin:0 0 10px">Registra los productos usados/entregados hoy. (Producto, Cantidad, Unidad, Salida, Notas)</p>
      <table class="itable" id="invTable">
        <thead>
          <tr>
            <th style="width:32%">Producto</th>
            <th style="width:12%">Cantidad</th>
            <th style="width:12%">Unidad</th>
            <th style="width:12%">Salida</th>
            <th>Notas</th>
            <th style="width:10%">Acción</th>
          </tr>
        </thead>
        <tbody id="invBody">
          <!-- filas dinámicas -->
        </tbody>
      </table>
      <div style="margin-top:10px">
        <button type="button" class="add-row" id="addRowBtn">+ Agregar producto</button>
      </div>
    </div>

    <!-- Submit -->
    <div class="submit" style="padding:0 16px 16px">
      <button type="submit">Enviar checklist por correo</button>
    </div>
  </form>
</div>

<script>
  // Tabs
  const tabButtons = document.querySelectorAll('.tabbar button');
  const tabs = document.querySelectorAll('.tab');
  tabButtons.forEach(btn=>{
    btn.addEventListener('click', ()=>{
      tabButtons.forEach(b=>b.classList.remove('active'));
      tabs.forEach(t=>t.classList.remove('active'));
      btn.classList.add('active');
      const id = btn.getAttribute('data-tab');
      document.getElementById(id).classList.add('active');
    });
  });

  // Inventario
  const invBody = document.getElementById('invBody');
  const addBtn  = document.getElementById('addRowBtn');
  let invIndex  = 0;

  const PRODUCTOS = <?php echo json_encode($inventoryProducts, JSON_UNESCAPED_UNICODE); ?>;

  function escapeHtml(s){
    if (s===undefined || s===null) return '';
    return String(s)
      .replaceAll('&', '&amp;')
      .replaceAll('<', '&lt;')
      .replaceAll('>', '&gt;')
      .replaceAll('"', '&quot;')
      .replaceAll("'", '&#039;');
  }

  function addRow(prefill){ // prefill: {producto,cantidad,unidad,salida,notas}
    prefill = Object.assign({producto:'', cantidad:'', unidad:'', salida:'', notas:''}, prefill||{});
    const tr = document.createElement('tr');
    tr.innerHTML = `
      <td><input type="text" name="inv[${invIndex}][producto]" value="${escapeHtml(prefill.producto)}" placeholder="Producto" style="width:100%;padding:8px;border:1px solid #e5e7eb;border-radius:8px;"></td>
      <td><input type="number" step="any" name="inv[${invIndex}][cantidad]" value="${escapeHtml(prefill.cantidad)}" placeholder="0" style="width:100%;padding:8px;border:1px solid #e5e7eb;border-radius:8px;"></td>
      <td><input type="text" name="inv[${invIndex}][unidad]" value="${escapeHtml(prefill.unidad)}" placeholder="pcs / L / kg" style="width:100%;padding:8px;border:1px solid #e5e7eb;border-radius:8px;"></td>
      <td><input type="number" step="any" name="inv[${invIndex}][salida]" value="${escapeHtml(prefill.salida)}" placeholder="0" style="width:100%;padding:8px;border:1px solid #e5e7eb;border-radius:8px;"></td>
      <td><input type="text" name="inv[${invIndex}][notas]" value="${escapeHtml(prefill.notas)}" placeholder="Observaciones" style="width:100%;padding:8px;border:1px solid #e5e7eb;border-radius:8px;"></td>
      <td class="row-actions"><button type="button" class="del-row" onclick="this.closest('tr').remove()">Eliminar</button></td>
    `;
    invBody.appendChild(tr);
    invIndex++;
  }

  // Precargar TODA la lista de productos (una fila por producto)
  PRODUCTOS.forEach(p => addRow({producto: p}));

  // Botón para agregar productos adicionales manualmente
  addBtn.addEventListener('click', ()=>addRow());
</script>
</body>
</html>
