<?php
session_start();
require_once __DIR__.'/config.php';

/* Debug temporal (quitar en producción) */
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (empty($_SESSION['autenticado']) && !SKIP_AUTH) {
  // header('Location: index.php'); exit();
}

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: checklist.php'); exit();
}

/* ===== Datos del formulario ===== */
$to      = filter_var($_POST['to'] ?? TO_EMAIL, FILTER_VALIDATE_EMAIL) ?: TO_EMAIL;
$client  = trim($_POST['client'] ?? '');
$by      = trim($_POST['by'] ?? '');
$name    = trim($_POST['name'] ?? '');
$title   = trim($_POST['title'] ?? '');
$date    = trim($_POST['date'] ?? date('Y-m-d'));

$tasks         = (isset($_POST['tasks']) && is_array($_POST['tasks'])) ? $_POST['tasks'] : array();
$task_names    = (isset($_POST['task_names']) && is_array($_POST['task_names'])) ? $_POST['task_names'] : array();
$section_names = (isset($_POST['section_names']) && is_array($_POST['section_names'])) ? $_POST['section_names'] : array();
$inv           = (isset($_POST['inv']) && is_array($_POST['inv'])) ? $_POST['inv'] : array();

/* ===== Días ===== */
$days = array("Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");

/* ===== Checklist: tabla HTML + texto ===== */
$rowsHtml = '';
$rowsTxt  = '';
foreach ($tasks as $secIndex => $taskList) {
  $sectionName = isset($section_names[$secIndex]) ? $section_names[$secIndex] : ("Section ".((int)$secIndex+1));
  $rowsHtml .= '<tr><td colspan="'.(count($days)+1).'" style="background:#1e637e;color:#fff;font-weight:700;padding:12px 14px;border:1px solid #e5e7eb;">'.h($sectionName).'</td></tr>';
  $rowsTxt  .= "== ".$sectionName." ==\r\n";
  foreach ($taskList as $taskIndex => $dayChecks) {
    $taskLabel = isset($task_names[$secIndex][$taskIndex]) ? $task_names[$secIndex][$taskIndex] : ("Task ".((int)$taskIndex+1));
    $rowsHtml .= '<tr><td style="padding:10px 12px;border:1px solid #e5e7eb;">'.h($taskLabel).'</td>';
    $txtLine = "- ".$taskLabel.": ";
    for ($d=0; $d<count($days); $d++){
      $checked = (is_array($dayChecks) && isset($dayChecks[$d]));
      $rowsHtml .= '<td style="text-align:center;border:1px solid #e5e7eb;font-weight:600;">'.($checked ? '&#10003;' : '').'</td>';
      $txtLine  .= $checked ? 'X' : '·';
      if ($d < count($days)-1) $txtLine .= ' ';
    }
    $rowsHtml .= '</tr>';
    $rowsTxt  .= $txtLine."\r\n";
  }
  $rowsTxt .= "\r\n";
}

/* ===== Meta (HTML) ===== */
$metaHtml  = '<table cellspacing="0" cellpadding="0" style="width:100%;margin:0 0 16px 0;border-collapse:collapse;">';
$metaHtml .= '<tr><td style="padding:6px 0;"><strong>Client:</strong> '.h($client).'</td><td style="padding:6px 0;"><strong>By:</strong> '.h($by).'</td></tr>';
$metaHtml .= '<tr><td style="padding:6px 0;"><strong>Name:</strong> '.h($name).'</td><td style="padding:6px 0;"><strong>Title:</strong> '.h($title).'</td></tr>';
$metaHtml .= '<tr><td style="padding:6px 0;"><strong>Date:</strong> '.h($date).'</td><td style="padding:6px 0;"></td></tr>';
$metaHtml .= '</table>';

/* Cabecera de tabla (HTML) */
$theadCells = '<th style="text-align:left;padding:12px 14px;border:1px solid #e5e7eb;background:#e9f1f4;">Task</th>';
for ($i=0; $i<count($days); $i++){
  $d = $days[$i];
  $theadCells .= '<th style="padding:12px 8px;border:1px solid #e5e7eb;background:#e9f1f4;">'.h($d).'</th>';
}
$tableHtml  = '<table cellspacing="0" cellpadding="0" style="width:100%;border-collapse:collapse;border:1px solid #e5e7eb;background:#ffffff;">';
$tableHtml .= '<thead><tr>'.$theadCells.'</tr></thead><tbody>'.$rowsHtml.'</tbody></table>';

/* ===== Inventario (si hay filas) ===== */
$hasInv = false;
$invHtmlRows = '';
$invTxt = '';
foreach ($inv as $row) {
  $prod   = trim($row['producto'] ?? '');
  $cant   = trim($row['cantidad'] ?? '');
  $unidad = trim($row['unidad'] ?? '');
  $salida = trim($row['salida'] ?? '');
  $notas  = trim($row['notas'] ?? '');
  if ($prod==='' && $cant==='' && $unidad==='' && $salida==='' && $notas==='') {
    continue;
  }
  $hasInv = true;
  $invHtmlRows .= '<tr>'.
    '<td style="padding:8px 10px;border:1px solid #e5e7eb;">'.h($prod).'</td>'.
    '<td style="padding:8px 10px;border:1px solid #e5e7eb;text-align:right;">'.h($cant).'</td>'.
    '<td style="padding:8px 10px;border:1px solid #e5e7eb;">'.h($unidad).'</td>'.
    '<td style="padding:8px 10px;border:1px solid #e5e7eb;text-align:right;">'.h($salida).'</td>'.
    '<td style="padding:8px 10px;border:1px solid #e5e7eb;">'.h($notas).'</td>'.
  '</tr>';

  $invTxt .= "- {$prod} | Cant: {$cant} {$unidad} | Salida: {$salida} | Notas: {$notas}\r\n";
}
$invHtml = '';
if ($hasInv) {
  $invHtml  = '<h3 style="margin:18px 0 8px;color:#1e637e">Inventario</h3>';
  $invHtml .= '<table cellspacing="0" cellpadding="0" style="width:100%;border-collapse:collapse;border:1px solid #e5e7eb;background:#ffffff;margin-top:6px">';
  $invHtml .= '<thead><tr>'.
    '<th style="text-align:left;padding:10px 12px;border:1px solid #e5e7eb;background:#e9f1f4;">Producto</th>'.
    '<th style="padding:10px 12px;border:1px solid #e5e7eb;background:#e9f1f4;">Cantidad</th>'.
    '<th style="padding:10px 12px;border:1px solid #e5e7eb;background:#e9f1f4;">Unidad</th>'.
    '<th style="padding:10px 12px;border:1px solid #e5e7eb;background:#e9f1f4;">Salida</th>'.
    '<th style="text-align:left;padding:10px 12px;border:1px solid #e5e7eb;background:#e9f1f4;">Notas</th>'.
  '</tr></thead><tbody>'.$invHtmlRows.'</tbody></table>';
}

/* ===== Cuerpos ===== */
$brand = '#1e637e';
$htmlHeader =
  '<div style="padding:18px 22px;background:linear-gradient(135deg,'.$brand.',#124452);color:#fff;display:flex;align-items:center;">'.
    '<div>'.
      '<div style="font-size:18px;font-weight:800;line-height:1">Cleaning Schedule</div>'.
      '<div style="opacity:.95;font-size:13px">Resumen de tareas marcadas por día</div>'.
    '</div>'.
    '<img src="https://thefreakyclean.com/wp-content/uploads/2024/04/Cleaning-Services-Charlotte-NC.png" alt="FreakyClean Logo" style="height:40px;display:block;margin-left:auto;">'.
  '</div>';

$htmlBody = '<!doctype html><html><head><meta charset="UTF-8"><title>Cleaning Schedule - '.h($date).'</title><meta name="viewport" content="width=device-width, initial-scale=1"></head>
<body style="margin:0;padding:0;background:#f1f5f9;font-family:ui-sans-serif,system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial;">
  <div style="max-width:900px;margin:24px auto;background:#ffffff;border-radius:12px;overflow:hidden;border:1px solid #e2e8f0;box-shadow:0 10px 20px rgba(2,6,23,.06);">'.
    $htmlHeader.
    '<div style="padding:22px 24px;">'.$metaHtml.$tableHtml.
      ($hasInv ? $invHtml : '').
      '<p style="margin:18px 0 0 0;font-size:12px;color:#64748b;">Enviado automáticamente por el sistema de checklist.</p>
    </div>
  </div></body></html>';

$plainBody = "Cleaning Schedule - {$date}\r\n\r\n"
  ."Client: {$client}\r\nBy: {$by}\r\nName: {$name}\r\nTitle: {$title}\r\nDate: {$date}\r\n\r\n"
  ."Días: ".implode(' ', $days)."\r\n"
  ."Marcas (X = hecho, · = sin marcar)\r\n\r\n"
  .$rowsTxt
  .($hasInv ? "\r\nInventario:\r\n".$invTxt : "")
  ."--\r\nEnviado automáticamente por el sistema de checklist.\r\n";

/* ===== MIME multipart/alternative con Base64 ===== */
$from      = 'info@thefreakyclean.com';   // remitente REAL del dominio
$subject   = "Cleaning Schedule - ".$date;
$boundary  = 'b'.md5(uniqid(time(), true));
$messageId = sprintf('<%s@thefreakyclean.com>', md5(uniqid('', true)));

$headers  = "Date: ".date('r')."\r\n";
$headers .= "Message-ID: {$messageId}\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "From: Cleaning Schedule <{$from}>\r\n";
$headers .= "Reply-To: {$from}\r\n";
$headers .= "List-Unsubscribe: <mailto:{$from}?subject=unsubscribe>\r\n";
$headers .= "X-Mailer: PHP/".phpversion()."\r\n";
$headers .= "Content-Type: multipart/alternative; boundary=\"{$boundary}\"\r\n";

/* Cuerpo MIME con partes Base64 */
$body  = "--{$boundary}\r\n";
$body .= "Content-Type: text/plain; charset=UTF-8\r\n";
$body .= "Content-Transfer-Encoding: base64\r\n\r\n";
$body .= chunk_split(base64_encode($plainBody));
$body .= "--{$boundary}\r\n";
$body .= "Content-Type: text/html; charset=UTF-8\r\n";
$body .= "Content-Transfer-Encoding: base64\r\n\r\n";
$body .= chunk_split(base64_encode($htmlBody));
$body .= "--{$boundary}--\r\n";

/* Envelope sender (Return-Path real via Exim/cPanel) */
$params = "-f {$from}";

/* Enviar */
$ok = @mail($to, $subject, $body, $headers, $params);

/* Log si falla */
if (!$ok) {
  $dbg  = "Fecha: ".date('c')."\n";
  $dbg .= "To: {$to}\nFrom: {$from}\nSubject: {$subject}\n";
  $dbg .= "PHP: ".phpversion()."\n";
  $dbg .= "headers:\n{$headers}\n\n";
  @file_put_contents(__DIR__."/mail_error.log", $dbg, FILE_APPEND);
}

/* Flash + redirect */
$_SESSION['flash'] = $ok
  ? array('type'=>'ok',  'text'=>'✅ ¡Checklist enviada correctamente a '.h($to).'!')
  : array('type'=>'err', 'text'=>'❌ No se pudo enviar el correo. Revisa SPF/DKIM/DMARC y el archivo mail_error.log.');

header('Location: checklist.php');
exit;
