<?php
session_start();
require_once __DIR__.'/config.php';

/* Debug temporal (quitar en producción) */
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (empty($_SESSION['autenticado']) && !SKIP_AUTH) {
  // header('Location: index.php'); exit();
}

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: checklist.php'); exit();
}

/* ====== Datos del formulario ====== */
$to      = filter_var($_POST['to'] ?? TO_EMAIL, FILTER_VALIDATE_EMAIL) ?: TO_EMAIL;
$client  = trim($_POST['client'] ?? '');
$by      = trim($_POST['by'] ?? '');
$name    = trim($_POST['name'] ?? '');
$title   = trim($_POST['title'] ?? '');
$date    = trim($_POST['date'] ?? date('Y-m-d'));

$tasks         = (isset($_POST['tasks']) && is_array($_POST['tasks'])) ? $_POST['tasks'] : array();
$task_names    = (isset($_POST['task_names']) && is_array($_POST['task_names'])) ? $_POST['task_names'] : array();
$section_names = (isset($_POST['section_names']) && is_array($_POST['section_names'])) ? $_POST['section_names'] : array();

/* ====== Días (columnas) ====== */
$days = array("Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");

/* ====== Construcción de la tabla desde el POST (nombres reales) ====== */
$rows = '';
foreach ($tasks as $secIndex => $taskList) {
  $sectionName = isset($section_names[$secIndex]) ? $section_names[$secIndex] : ("Section ".((int)$secIndex+1));
  $rows .= '<tr><td colspan="'.(count($days)+1).'" style="background:#1e637e;color:#fff;font-weight:700;padding:12px 14px;border:1px solid #e5e7eb;">'.h($sectionName).'</td></tr>';

  foreach ($taskList as $taskIndex => $dayChecks) {
    $taskLabel = isset($task_names[$secIndex][$taskIndex]) ? $task_names[$secIndex][$taskIndex] : ("Task ".((int)$taskIndex+1));
    $rows .= '<tr><td style="padding:10px 12px;border:1px solid #e5e7eb;">'.h($taskLabel).'</td>';
    for ($d=0; $d<count($days); $d++){
      $checked = (is_array($dayChecks) && isset($dayChecks[$d])) ? '&#10003;' : '';
      $rows .= '<td style="text-align:center;border:1px solid #e5e7eb;font-weight:600;">'.$checked.'</td>';
    }
    $rows .= '</tr>';
  }
}

/* ====== Meta superior ====== */
$meta  = '<table cellspacing="0" cellpadding="0" style="width:100%;margin:0 0 16px 0;border-collapse:collapse;">';
$meta .= '<tr><td style="padding:6px 0;"><strong>Client:</strong> '.h($client).'</td><td style="padding:6px 0;"><strong>By:</strong> '.h($by).'</td></tr>';
$meta .= '<tr><td style="padding:6px 0;"><strong>Name:</strong> '.h($name).'</td><td style="padding:6px 0;"><strong>Title:</strong> '.h($title).'</td></tr>';
$meta .= '<tr><td style="padding:6px 0;"><strong>Date:</strong> '.h($date).'</td><td style="padding:6px 0;"></td></tr>';
$meta .= '</table>';

/* ====== Cabecera de tabla ====== */
$theadCells = '<th style="text-align:left;padding:12px 14px;border:1px solid #e5e7eb;background:#e9f1f4;">Task</th>';
for ($i=0; $i<count($days); $i++){
  $d = $days[$i];
  $theadCells .= '<th style="padding:12px 8px;border:1px solid #e5e7eb;background:#e9f1f4;">'.h($d).'</th>';
}

$table  = '<table cellspacing="0" cellpadding="0" style="width:100%;border-collapse:collapse;border:1px solid #e5e7eb;background:#ffffff;">';
$table .= '<thead><tr>'.$theadCells.'</tr></thead><tbody>'.$rows.'</tbody></table>';

/* ====== HTML del correo ====== */
$brand = '#1e637e';
$html = '<!doctype html><html><head><meta charset="UTF-8"><title>Cleaning Schedule - '.h($date).'</title><meta name="viewport" content="width=device-width, initial-scale=1"></head>
<body style="margin:0;padding:0;background:#f1f5f9;font-family:ui-sans-serif,system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial;">
  <div style="max-width:900px;margin:24px auto;background:#ffffff;border-radius:12px;overflow:hidden;border:1px solid #e2e8f0;box-shadow:0 10px 20px rgba(2,6,23,.06);">
    <div style="padding:18px 22px;background:linear-gradient(135deg,'.$brand.',#124452);color:#fff;">
      <div style="font-size:18px;font-weight:800;line-height:1">Cleaning Schedule</div>
      <div style="opacity:.95;font-size:13px">Resumen de tareas marcadas por día</div>
    </div>
    <div style="padding:22px 24px;">'.$meta.$table.'
      <p style="margin:18px 0 0 0;font-size:12px;color:#64748b;">Enviado automáticamente por el sistema de checklist.</p>
    </div>
  </div></body></html>';

/* ====== Cabeceras y envío con mail() + envelope sender ====== */
$from = 'info@thefreakyclean.com'; // remitente de TU dominio
$subject = "Cleaning Schedule - ".$date;

/* Cuerpo en base64 para compatibilidad */
$encodedBody = chunk_split(base64_encode($html));

$headers  = "MIME-Version: 1.0\r\n";
$headers .= "Content-Type: text/html; charset=UTF-8\r\n";
$headers .= "Content-Transfer-Encoding: base64\r\n";
$headers .= "From: Cleaning Schedule <{$from}>\r\n";
$headers .= "Reply-To: {$from}\r\n";
$headers .= "Return-Path: {$from}\r\n";
$headers .= "X-Mailer: PHP/".phpversion()."\r\n";

/* Envelope sender (Exim/cPanel) */
$params = "-f {$from}";

/* Enviar */
$ok = @mail($to, $subject, $encodedBody, $headers, $params);

/* Log si falla */
if (!$ok) {
  $dbg  = "Fecha: ".date('c')."\n";
  $dbg .= "To: {$to}\nFrom: {$from}\nSubject: {$subject}\n";
  $dbg .= "PHP: ".phpversion()."\n";
  $dbg .= "headers:\n{$headers}\n\n";
  @file_put_contents(__DIR__."/mail_error.log", $dbg, FILE_APPEND);
}

/* Flash + redirect */
$_SESSION['flash'] = $ok
  ? array('type'=>'ok',  'text'=>'✅ ¡Checklist enviada correctamente a '.h($to).'!')
  : array('type'=>'err', 'text'=>'❌ No se pudo enviar el correo. Verifica remitente/dominio y revisa mail_error.log.');

header('Location: checklist.php');
exit;
